function getHitShapeOnCanvasPointerDown(editor, hitLabels = false) {
  const zoomLevel = editor.getZoomLevel();
  const {
    inputs: { currentPagePoint }
  } = editor;
  return (
    // hovered shape at point
    (// selected shape at point
    editor.getShapeAtPoint(currentPagePoint, {
      hitInside: false,
      hitLabels,
      margin: editor.options.hitTestMargin / zoomLevel,
      renderingOnly: true
    }) ?? editor.getSelectedShapeAtPoint(currentPagePoint))
  );
}
export {
  getHitShapeOnCanvasPointerDown
};
//# sourceMappingURL=getHitShapeOnCanvasPointerDown.mjs.map
